/*
 * Decompiled with CFR 0.152.
 */
package cn.wch.uartlib;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Build;
import androidx.annotation.NonNull;
import cn.wch.uartlib.base.error.SerialErrorType;
import cn.wch.uartlib.base.gpio.GPIO_DIR;
import cn.wch.uartlib.base.gpio.GPIO_Status;
import cn.wch.uartlib.base.gpio.GPIO_VALUE;
import cn.wch.uartlib.base.other.ChipMasterFrequency;
import cn.wch.uartlib.c.b.a;
import cn.wch.uartlib.callback.IDataCallback;
import cn.wch.uartlib.callback.IModemStatus;
import cn.wch.uartlib.callback.IUsbStateChange;
import cn.wch.uartlib.chip.type.ChipType2;
import cn.wch.uartlib.d.d;
import cn.wch.uartlib.exception.ChipException;
import cn.wch.uartlib.exception.NoPermissionException;
import cn.wch.uartlib.exception.UartLibException;
import cn.wch.uartlib.g.b;
import cn.wch.uartlib.g.c;
import cn.wch.uartlib.receiver.UsbReceiver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public final class WCHUARTManager
implements IUsbStateChange {
    private static WCHUARTManager h;
    private static volatile boolean i = false;
    private static volatile int j = 0;
    private UsbManager a;
    private UsbReceiver b;
    private boolean c = false;
    private HashMap<UsbDevice, d> d;
    private HashMap<UsbDevice, IDataCallback> e;
    private IUsbStateChange f = null;
    private AtomicInteger g;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WCHUARTManager getInstance() {
        if (h == null) {
            Class<WCHUARTManager> clazz = WCHUARTManager.class;
            synchronized (WCHUARTManager.class) {
                h = new WCHUARTManager();
            }
        }
        return h;
    }

    private WCHUARTManager() {
        HashMap hashMap;
        HashMap hashMap2;
        AtomicInteger atomicInteger;
        Object object = atomicInteger;
        atomicInteger = new AtomicInteger(110);
        v1.g = object;
        object = hashMap2;
        hashMap2 = new HashMap();
        v1.d = object;
        object = hashMap;
        hashMap = new HashMap();
        v1.e = object;
    }

    private void a(@NonNull Context context) {
        UsbReceiver usbReceiver;
        IntentFilter intentFilter;
        IntentFilter intentFilter2 = intentFilter;
        new IntentFilter().addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        intentFilter2.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        intentFilter2.addAction("cn.wch.uartlib.permission");
        UsbReceiver usbReceiver2 = usbReceiver;
        this.b = new UsbReceiver();
        if (Build.VERSION.SDK_INT >= 33) {
            context.registerReceiver((BroadcastReceiver)usbReceiver2, intentFilter2, 4);
        } else {
            context.registerReceiver((BroadcastReceiver)usbReceiver2, intentFilter2);
        }
        this.c = true;
        this.b.a(this);
    }

    private void b(@NonNull Context context) {
        if (this.c) {
            this.c = false;
            context.unregisterReceiver((BroadcastReceiver)this.b);
        }
    }

    private void a(@NonNull UsbDevice usbDevice) {
        WCHUARTManager wCHUARTManager = this;
        cn.wch.uartlib.g.b.a("passive disconnect " + usbDevice.getDeviceName());
        wCHUARTManager.removeDataCallback(usbDevice);
        cn.wch.uartlib.b.b.b.a().a(usbDevice);
        cn.wch.uartlib.b.b.a.a().a(usbDevice);
        d d2 = wCHUARTManager.d.get(usbDevice);
        if (d2 != null) {
            d2.a();
            this.d.remove(usbDevice);
        }
    }

    public static void setReadTimeout(int n2) {
        j = n2;
    }

    public static int getReadTimeout() {
        return j;
    }

    public static void addNewHardware(int n2, int n3) {
        cn.wch.uartlib.c.b.a.a(n2, n3);
    }

    public static void addNewHardwareAndChipType(int n2, int n3, ChipType2 chipType2) {
        int n4 = n2;
        WCHUARTManager.addNewHardware(n4, n3);
        cn.wch.uartlib.c.b.b.a(n4, n3, chipType2);
    }

    public static void setDebug(boolean bl) {
        i = bl;
    }

    public static boolean isDebugMode() {
        return i;
    }

    public static void setReceiveBufferSize(int n2) {
        cn.wch.uartlib.d.d.u = n2;
    }

    public void init(Application application) {
        this.a = (UsbManager)application.getSystemService("usb");
        if (!this.c) {
            this.a((Context)application);
        }
    }

    public ArrayList<UsbDevice> enumDevice() throws Exception {
        WCHUARTManager wCHUARTManager = wCHUARTManager.a;
        if (wCHUARTManager != null) {
            return cn.wch.uartlib.g.c.a((UsbManager)wCHUARTManager);
        }
        throw new UartLibException("invoke method init() firstly in Application");
    }

    public ChipType2 getChipType(@NonNull UsbDevice usbDevice) {
        ChipType2 chipType2 = cn.wch.uartlib.c.e.c.b(usbDevice);
        if (chipType2 != null) {
            return chipType2;
        }
        d d2 = ((WCHUARTManager)((Object)d2)).d.get(usbDevice);
        if (d2 == null) {
            cn.wch.uartlib.g.b.a("the usb device isn't connected");
            return null;
        }
        return cn.wch.uartlib.c.e.c.a(d2.e(), usbDevice);
    }

    public boolean openDevice(@NonNull UsbDevice usbDevice) throws UartLibException, NoPermissionException, ChipException {
        Object object = this.a;
        if (object != null) {
            if (cn.wch.uartlib.g.c.a(object, usbDevice)) {
                d d2;
                if (this.isConnected(usbDevice)) {
                    return true;
                }
                object = d2;
                new d(this.a, usbDevice).g();
                this.d.put(usbDevice, (d)object);
                return true;
            }
            throw new NoPermissionException("No permission: " + usbDevice.toString());
        }
        throw new UartLibException("invoke method init() firstly in Application");
    }

    public void requestPermission(@NonNull Context context, @NonNull UsbDevice usbDevice) throws Exception {
        UsbManager usbManager = this.a;
        if (usbManager != null) {
            if (!cn.wch.uartlib.g.c.a(usbManager, usbDevice)) {
                cn.wch.uartlib.g.c.a(this.a, context, usbDevice, this.g.getAndIncrement());
            }
            return;
        }
        throw new UartLibException("invoke method init() firstly in Application");
    }

    public void setUsbStateListener(IUsbStateChange iUsbStateChange) {
        this.f = iUsbStateChange;
    }

    public int getSerialCount(@NonNull UsbDevice usbDevice) throws Exception {
        d d2 = ((WCHUARTManager)((Object)d2)).d.get(usbDevice);
        if (d2 != null) {
            return d2.b().c();
        }
        throw new UartLibException("the usbDevice isn't connected");
    }

    public boolean enableSerial(@NonNull UsbDevice usbDevice, int n2, boolean bl) throws Exception {
        Object object = object.d.get(usbDevice);
        if (object != null) {
            int n3 = object.b().c();
            if (n2 >= 0 && n2 < n3) {
                return object.a(n2, bl);
            }
            Object[] objectArray = new Object[1];
            object = objectArray;
            objectArray[0] = n3;
            throw new ChipException(String.format(Locale.getDefault(), "the usbDevice only has %d COM", object));
        }
        throw new UartLibException("the usbDevice isn't connected");
    }

    public boolean setSerialParameter(@NonNull UsbDevice usbDevice, int n2, int n3, int n4, int n5, int n6, boolean bl) throws Exception {
        Object object = object.d.get(usbDevice);
        if (object != null) {
            int n7 = object.b().c();
            if (n2 >= 0 && n2 < n7) {
                return object.a(n2, n3, n4, n5, n6, bl);
            }
            Object[] objectArray = new Object[1];
            object = objectArray;
            objectArray[0] = n7;
            throw new ChipException(String.format(Locale.getDefault(), "the usbDevice only has %d COM", object));
        }
        throw new UartLibException("the usbDevice isn't connected");
    }

    public int getSerialBaud(@NonNull UsbDevice usbDevice, int n2) throws Exception {
        Object object = object.d.get(usbDevice);
        if (object != null) {
            int n3 = object.b().c();
            if (n2 >= 0 && n2 < n3) {
                return object.c(n2);
            }
            Object[] objectArray = new Object[1];
            object = objectArray;
            objectArray[0] = n3;
            throw new ChipException(String.format(Locale.getDefault(), "the usbDevice only has %d COM", object));
        }
        throw new UartLibException("the usbDevice isn't connected");
    }

    public ChipMasterFrequency getChipMasterFrequency(@NonNull UsbDevice usbDevice) throws Exception {
        d d2 = ((WCHUARTManager)((Object)d2)).d.get(usbDevice);
        if (d2 != null) {
            return d2.c();
        }
        throw new UartLibException("the usbDevice isn't connected");
    }

    public boolean setDTR(@NonNull UsbDevice usbDevice, int n2, boolean bl) throws Exception {
        Object object = object.d.get(usbDevice);
        if (object != null) {
            int n3 = object.b().c();
            if (n2 >= 0 && n2 < n3) {
                return object.c(n2, bl);
            }
            Object[] objectArray = new Object[1];
            object = objectArray;
            objectArray[0] = n3;
            throw new ChipException(String.format(Locale.getDefault(), "the usbDevice only has %d COM", object));
        }
        throw new UartLibException("the usbDevice isn't connected");
    }

    public boolean setRTS(@NonNull UsbDevice usbDevice, int n2, boolean bl) throws Exception {
        Object object = object.d.get(usbDevice);
        if (object != null) {
            int n3 = object.b().c();
            if (n2 >= 0 && n2 < n3) {
                return object.d(n2, bl);
            }
            Object[] objectArray = new Object[1];
            object = objectArray;
            objectArray[0] = n3;
            throw new ChipException(String.format(Locale.getDefault(), "the usbDevice only has %d COM", object));
        }
        throw new UartLibException("the usbDevice isn't connected");
    }

    public boolean setBreak(@NonNull UsbDevice usbDevice, int n2, boolean bl) throws Exception {
        Object object = object.d.get(usbDevice);
        if (object != null) {
            int n3 = object.b().c();
            if (n2 >= 0 && n2 < n3) {
                return object.b(n2, bl);
            }
            Object[] objectArray = new Object[1];
            object = objectArray;
            objectArray[0] = n3;
            throw new ChipException(String.format(Locale.getDefault(), "the usbDevice only has %d COM", object));
        }
        throw new UartLibException("the usbDevice isn't connected");
    }

    public void registerModemStatusCallback(@NonNull UsbDevice usbDevice, IModemStatus iModemStatus) throws Exception {
        d d2 = ((WCHUARTManager)((Object)d2)).d.get(usbDevice);
        if (d2 != null) {
            d2.a(iModemStatus);
            cn.wch.uartlib.g.b.a("register modem callback");
            return;
        }
        throw new UartLibException("the usbDevice isn't connected");
    }

    public int querySerialErrorCount(@NonNull UsbDevice usbDevice, int n2, @NonNull SerialErrorType serialErrorType) throws Exception {
        Object object = object.d.get(usbDevice);
        if (object != null) {
            int n3 = object.b().c();
            if (n2 >= 0 && n2 < n3) {
                return object.a(n2, serialErrorType);
            }
            Object[] objectArray = new Object[1];
            object = objectArray;
            objectArray[0] = n3;
            throw new ChipException(String.format(Locale.getDefault(), "the usbDevice only has %d COM", object));
        }
        throw new UartLibException("the usbDevice isn't connected");
    }

    public int syncWriteData(@NonNull UsbDevice usbDevice, int n2, byte[] byArray, int n3, int n4) throws Exception {
        Object object = object.d.get(usbDevice);
        if (object != null) {
            int n5 = object.b().c();
            if (n2 >= 0 && n2 < n5) {
                return object.a(n2, byArray, n3, n4);
            }
            Object[] objectArray = new Object[1];
            object = objectArray;
            objectArray[0] = n5;
            throw new ChipException(String.format(Locale.getDefault(), "the usbDevice only has %d COM", object));
        }
        throw new UartLibException("the usbDevice isn't connected");
    }

    public void asyncWriteData(@NonNull UsbDevice usbDevice, int n2, byte[] byArray) throws Exception {
        Object object = object.d.get(usbDevice);
        if (object != null) {
            int n3 = object.b().c();
            if (n2 >= 0 && n2 < n3) {
                object.a(n2, byArray);
                return;
            }
            Object[] objectArray = new Object[1];
            object = objectArray;
            objectArray[0] = n3;
            throw new ChipException(String.format(Locale.getDefault(), "the usbDevice only has %d COM", object));
        }
        throw new UartLibException("the usbDevice isn't connected");
    }

    public byte[] readData(@NonNull UsbDevice usbDevice, int n2) throws Exception {
        d d2 = ((WCHUARTManager)((Object)d2)).d.get(usbDevice);
        if (d2 != null) {
            return d2.e(n2);
        }
        throw new ChipException("this device isn't connected");
    }

    public byte[] readData(@NonNull UsbDevice usbDevice, int n2, int n3) throws Exception {
        d d2 = ((WCHUARTManager)((Object)d2)).d.get(usbDevice);
        if (d2 != null) {
            return d2.a(n2, n3);
        }
        throw new ChipException("this device isn't connected");
    }

    public byte[] readData(@NonNull UsbDevice usbDevice, int n2, int n3, int n4) throws Exception {
        d d2 = ((WCHUARTManager)((Object)d2)).d.get(usbDevice);
        if (d2 != null) {
            if (n3 > 0 && n4 > 0) {
                return d2.b(n2, n3, n4);
            }
            if (n3 > 0 && n4 == 0) {
                return d2.b(n2, n3);
            }
            if (n3 == 0 && n4 > 0) {
                return d2.c(n2, n4);
            }
            throw new ChipException("vTime or vMin can't be less than 0");
        }
        throw new ChipException("this device isn't connected");
    }

    public byte[] readDataAndWaitIfEmpty(@NonNull UsbDevice usbDevice, int n2, int n3) throws Exception {
        Object object = ((WCHUARTManager)object).d.get(usbDevice);
        if (object != null) {
            object = ((d)object).e(n2);
            if (n3 > 0 && (object == null || ((Object)object).length == 0)) {
                try {
                    Thread.sleep(n3);
                }
                catch (Exception exception) {
                    cn.wch.uartlib.g.b.a(exception.getMessage());
                }
            }
            return object;
        }
        throw new ChipException("this device isn't connected");
    }

    public int getCurrentReadDataLength(@NonNull UsbDevice usbDevice, int n2) throws Exception {
        d d2 = ((WCHUARTManager)((Object)d2)).d.get(usbDevice);
        if (d2 != null) {
            return d2.a(n2);
        }
        throw new ChipException("this device isn't connected");
    }

    public void registerDataCallback(@NonNull UsbDevice usbDevice, IDataCallback iDataCallback) throws Exception {
        d d2 = ((WCHUARTManager)((Object)d2)).d.get(usbDevice);
        if (d2 != null) {
            d2.a(iDataCallback);
            cn.wch.uartlib.g.b.a("register data callback");
            return;
        }
        throw new ChipException("the device isn't connected");
    }

    public void removeDataCallback(@NonNull UsbDevice usbDevice) {
        d d2 = ((WCHUARTManager)((Object)d2)).d.get(usbDevice);
        if (d2 != null) {
            d d3 = d2;
            d3.a((IDataCallback)null);
            d3.a((IModemStatus)null);
            cn.wch.uartlib.g.b.a("remove data callback");
        }
    }

    public boolean isConnected(@NonNull UsbDevice usbDevice) {
        d d2 = ((WCHUARTManager)((Object)d2)).d.get(usbDevice);
        if (d2 == null) {
            return false;
        }
        return d2.h();
    }

    public ArrayList<UsbDevice> getConnectedDevices() {
        ArrayList<UsbDevice> arrayList;
        Set<UsbDevice> set = ((WCHUARTManager)((Object)set)).d.keySet();
        ArrayList<UsbDevice> arrayList2 = arrayList;
        arrayList = new ArrayList<UsbDevice>(set);
        cn.wch.uartlib.g.b.a("current connected device count:" + arrayList2.size());
        return arrayList;
    }

    public void disconnect(@NonNull UsbDevice usbDevice) {
        cn.wch.uartlib.g.b.a("disconnect #1" + usbDevice.getDeviceName());
        this.removeDataCallback(usbDevice);
        int n2 = 0;
        try {
            n2 = this.getSerialCount(usbDevice);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = 0;
            try {
                by = cn.wch.uartlib.b.b.b.a().b(usbDevice, i2);
            }
            catch (UartLibException uartLibException) {
                cn.wch.uartlib.g.b.a(uartLibException.getMessage());
            }
            if (by == 0) continue;
            WCHUARTManager wCHUARTManager = this;
            UsbDevice usbDevice2 = usbDevice;
            int n3 = i2;
            WCHUARTManager wCHUARTManager2 = this;
            UsbDevice usbDevice3 = usbDevice;
            int n4 = i2;
            this.setDTR(usbDevice, i2, false);
            wCHUARTManager2.setRTS(usbDevice3, n4, false);
            try {
                wCHUARTManager.setSerialParameter(usbDevice2, n3, 115200, 8, 1, 0, false);
            }
            catch (Exception exception) {
                cn.wch.uartlib.g.b.a(exception.getMessage());
            }
            continue;
        }
        cn.wch.uartlib.b.b.b.a().a(usbDevice);
        cn.wch.uartlib.b.b.a.a().a(usbDevice);
        d d2 = this.d.get(usbDevice);
        if (d2 != null) {
            d2.a();
            this.d.remove(usbDevice);
        }
    }

    public void close(@NonNull Context context) {
        Iterator<UsbDevice> iterator = this.getConnectedDevices().iterator();
        while (iterator.hasNext()) {
            this.disconnect(iterator.next());
        }
        this.b(context);
    }

    @Override
    public void usbDeviceDetach(UsbDevice usbDevice) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = usbDevice.getDeviceName();
        cn.wch.uartlib.g.b.a(String.format(Locale.getDefault(), "device %s detach", objectArray2));
        if (((WCHUARTManager)iUsbStateChange).d.get(usbDevice) == null) {
            return;
        }
        WCHUARTManager wCHUARTManager = iUsbStateChange;
        wCHUARTManager.a(usbDevice);
        IUsbStateChange iUsbStateChange = wCHUARTManager.f;
        if (iUsbStateChange != null) {
            iUsbStateChange.usbDeviceDetach(usbDevice);
        }
    }

    @Override
    public void usbDeviceAttach(UsbDevice usbDevice) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = usbDevice.getDeviceName();
        cn.wch.uartlib.g.b.a(String.format(Locale.getDefault(), "device %s attach", objectArray2));
        if (!cn.wch.uartlib.c.b.a.b(usbDevice.getVendorId(), usbDevice.getProductId())) {
            return;
        }
        IUsbStateChange iUsbStateChange = ((WCHUARTManager)iUsbStateChange).f;
        if (iUsbStateChange != null) {
            iUsbStateChange.usbDeviceAttach(usbDevice);
        }
    }

    @Override
    public void usbDevicePermission(UsbDevice usbDevice, boolean bl) {
        if (!cn.wch.uartlib.c.b.a.b(usbDevice.getVendorId(), usbDevice.getProductId())) {
            return;
        }
        IUsbStateChange iUsbStateChange = ((WCHUARTManager)iUsbStateChange).f;
        if (iUsbStateChange != null) {
            iUsbStateChange.usbDevicePermission(usbDevice, bl);
        }
    }

    public boolean isSupportGPIOFeature(UsbDevice usbDevice) throws Exception {
        d d2 = ((WCHUARTManager)((Object)d2)).d.get(usbDevice);
        if (d2 != null) {
            return d2.i();
        }
        throw new UartLibException("the usbDevice isn't connected");
    }

    public int queryGPIOCount(UsbDevice usbDevice) throws Exception {
        if (((WCHUARTManager)((Object)d2)).isSupportGPIOFeature(usbDevice)) {
            d d2 = ((WCHUARTManager)((Object)d2)).d.get(usbDevice);
            if (d2 != null) {
                return d2.k();
            }
            throw new UartLibException("the usbDevice isn't connected");
        }
        throw new Exception("Not support GPIO!");
    }

    public GPIO_Status queryGPIOStatus(UsbDevice usbDevice, int n2) throws Exception {
        if (((WCHUARTManager)((Object)d2)).isSupportGPIOFeature(usbDevice)) {
            d d2 = ((WCHUARTManager)((Object)d2)).d.get(usbDevice);
            if (d2 != null) {
                return d2.d(n2);
            }
            throw new UartLibException("the usbDevice isn't connected");
        }
        throw new Exception("Not support GPIO!");
    }

    public List<GPIO_Status> queryAllGPIOStatus(UsbDevice usbDevice) throws Exception {
        if (((WCHUARTManager)((Object)d2)).isSupportGPIOFeature(usbDevice)) {
            d d2 = ((WCHUARTManager)((Object)d2)).d.get(usbDevice);
            if (d2 != null) {
                return d2.j();
            }
            throw new UartLibException("the usbDevice isn't connected");
        }
        throw new Exception("Not support GPIO!");
    }

    public boolean enableGPIO(UsbDevice usbDevice, int n2, boolean bl, GPIO_DIR gPIO_DIR) throws Exception {
        if (((WCHUARTManager)((Object)d2)).isSupportGPIOFeature(usbDevice)) {
            d d2 = ((WCHUARTManager)((Object)d2)).d.get(usbDevice);
            if (d2 != null) {
                return d2.a(n2, bl, gPIO_DIR);
            }
            throw new UartLibException("the usbDevice isn't connected");
        }
        throw new Exception("Not support GPIO!");
    }

    public boolean setGPIOVal(UsbDevice usbDevice, int n2, GPIO_VALUE gPIO_VALUE) throws Exception {
        if (((WCHUARTManager)((Object)d2)).isSupportGPIOFeature(usbDevice)) {
            d d2 = ((WCHUARTManager)((Object)d2)).d.get(usbDevice);
            if (d2 != null) {
                return d2.a(n2, gPIO_VALUE);
            }
            throw new UartLibException("the usbDevice isn't connected");
        }
        throw new Exception("Not support GPIO!");
    }

    public GPIO_VALUE getGPIOVal(UsbDevice usbDevice, int n2) throws Exception {
        if (((WCHUARTManager)((Object)d2)).isSupportGPIOFeature(usbDevice)) {
            d d2 = ((WCHUARTManager)((Object)d2)).d.get(usbDevice);
            if (d2 != null) {
                return d2.b(n2);
            }
            throw new UartLibException("the usbDevice isn't connected");
        }
        throw new Exception("Not support GPIO!");
    }
}

