//
//*******************************************
//**  Copyright  (C)  WCH  2004-2023       **
//**  Web:  http://wch.cn                  **
//*******************************************
//**  DLL for USB to uart chip CH34X/CH910X**
//**  C, VC6.0                             **
//*******************************************
//
// USB߽ӿоƬ˿ڹӿڿ V1.5
// Ͼߺ΢
// CH34X-Port-DLL  V1.5
// л: Windows 98/ME, Windows 2000/XP,Windows 7/8/10/11
// support USB chip: CH34X/CH910X/CH344/CH347/CH348
// USB => Single/Multi serial port
//

#ifndef		_CH343_PORT_H
#define		_CH343_PORT_H

#ifdef __cplusplus
extern "C" {
#endif
	
//WCHͺ
//δ֪ͺ
#define USER_TYPE_Unknown   0xFF
//USBת1
#define USER_TYPE_CH341     0x10
//USBת2
#define USER_TYPE_CH340     0x20
#define USER_TYPE_CH340K    0x21
#define USER_TYPE_CH330     0x22
#define USER_TYPE_CH9340    0x23
#define USER_TYPE_CH9340K   0x24
#define USER_TYPE_CH9340C   0x25
#define USER_TYPE_CH34E     0x26
#define USER_TYPE_CH34X     0x27
//USBת3
#define USER_TYPE_CH343K    0x30
#define USER_TYPE_CH343J    0x31
#define USER_TYPE_CH343G    0x32 //CH343G/P
#define USER_TYPE_CH343P    0x33
//USBת4,CH9101U/Hͬ
#define USER_TYPE_CH9101U   0x40
#define USER_TYPE_CH9101H   0x40
//USBת4,CH9101R/Yͬ
#define USER_TYPE_CH9101R   0x41
#define USER_TYPE_CH9101Y   0x41
#define USER_TYPE_CH9101N   0x42
//USBת5
#define USER_TYPE_CH9102F   0x50
#define USER_TYPE_CH9102X   0x51
//USBת6
#define USER_TYPE_CH9103M   0x60

//USBת˫
#define USER_TYPE_CH342F    0xA0
#define USER_TYPE_CH342K    0xA1
#define USER_TYPE_CH342J    0xA2
#define USER_TYPE_CH342G    0xA3
#define USER_TYPE_CH347T    0xA4
//USBתĴ
#define USER_TYPE_CH9344    0xD0
#define USER_TYPE_CH344L    0xD1
#define USER_TYPE_CH344Q    0xD2
#define USER_TYPE_CH9104L   0xD3

//USBת˴
#define USER_TYPE_CH348L     0xE0
#define USER_TYPE_CH348Q     0xE1

// Return value
#define     CH910x_SUCCESS                      0x00
#define     CH910x_INVALID_HANDLE               0x01
#define     CH910x_INVALID_PARAMETER            0x02
#define     CH910x_DEVICE_IO_FAILED             0x03
#define     CH910x_FUNCTION_NOT_SUPPORTED       0x04
#define     CH910x_NOT_INIT                     0x05

// GPIO mask bit definitions
#define     CH910x_GPIO_0         0x0001
#define     CH910x_GPIO_1         0x0002
#define     CH910x_GPIO_2         0x0004
#define     CH910x_GPIO_3         0x0008
#define     CH910x_GPIO_4         0x0010
#define     CH910x_GPIO_5         0x0020
#define     CH910x_GPIO_6         0x0040
#define     CH910x_GPIO_7         0x0080
#define     CH910x_GPIO_8         0x0100
#define     CH910x_GPIO_9         0x0200
#define     CH910x_GPIO_10        0x0400
#define     CH910x_GPIO_11        0x0800
#define     CH910x_GPIO_12        0x1000
#define     CH910x_GPIO_13        0x2000
#define     CH910x_GPIO_14        0x4000
#define     CH910x_GPIO_15        0x8000

//оƬϢṹ
typedef struct _USBSER_Property
{
	UCHAR    ChipType;              //оƬͺ,USER_TYPE_CHxxx	
	CHAR     ChipTypeStr[32];       //оƬͺַ
	CHAR     FwVerStr[32];          //̼汾ַ
	UCHAR    GpioCount;             //GPIO,0ͺרGPIOŻý;Ϊ0ʾоƬ֧GPIO
	BOOL     IsEmbbedEeprom;        //ǷEEPROM,֧֣ɽ豸Ϣ	
	BOOL     IsSupportMcuBootCtrl;  //Ƿ֧ModemΪ103 MCUؿ
	CHAR     ManufacturerString[64];//USBڳַ
	CHAR     ProductString[64];     //USBڲƷַ
	USHORT   bcdDevice;             //USBbcdDeviceֵ
	UCHAR    PortIndex;             //Ϊ0മΪоƬڼŴ
	BOOL     IsSupportGPIOInit;     //Ƿ֧GPIOϵʼ
	CHAR     PortName[32];          //ں
	ULONG    ResvD[8];              //Ԥ
}ChipPropertyS,*pChipPropertyS;

//CH340CH341֮USBоƬEEPROM
typedef struct _USERCFG_343
{
	UCHAR SIG;      // CH340BڲϢЧ־ 5BH
	// CH340H/SⲿоƬЧ־ 53H
	// CH343??ⲿоƬЧ־ 53H
	//ֵЧ
	UCHAR MODE;     //ģʽ23H
	UCHAR CFG;      //оƬֽ
	//BIT7USB豸кַλ1=Ч0=Ч
	//BIT6USBƷϢַλ1=Ч0=Ч
	//BIT5USBϢַλ1=Ч0=Ч
	//BIT4CDCģʽǷӲأ1=ã0=ֹ
	//BIT3оƬǷEEPROMĬãоƬϵEEPROMеóʼŷ򼰵ƽ״̬Լʹ״ֵ̬˵ 1=ã0=ֹ
	UCHAR WP;       //ڲϢд־Ϊ 57H ֻɸд
	UCHAR Vid[2];   //Vendor IDʶ룬ֽںֵ
	UCHAR Pid[2];   //Product IDƷʶ룬ֽںֵ
	UCHAR BCD[2];   //ֽں,ֵ
	UCHAR Power;    //Max PowerUSB,2mAΪλԴ
	UCHAR Attributes;//	USB緽ʽ˯߻ѵȹϢ
	//BIT7ó1
	//BIT61= Self-Powered
	//0=Bus-Powered
	//BIT51= Remote Wakeup Enable
	//0= Remote Wakeup Disable
	//BIT4-BIT0ó0
	UCHAR Reserved[4]; //ֽ00HFFH
	CHAR  SN[24];    //USB豸кַ.ֽȫֽ(16H)ֽڿʼΪ׼USBַʽ(1ֽΪܳȣ2ֽڹ̶Ϊ03H3ֽڿʼΪUnicodeַ,żΪ0x00)ʹóĬ˵
	UCHAR PROD[40];  //USBƷϢַ.ֽȫֽ(28H)ֽڿʼΪ׼USBַʽ(1ֽΪܳȣ2ֽڹ̶Ϊ03H3ֽڿʼΪUnicodeַ,żΪ0x00)ʹóĬ˵
	UCHAR MAU[40];   //USBϢַ.ֽȫֽ(28H)ֽڿʼΪ׼USBַʽ(1ֽΪܳȣ2ֽڹ̶Ϊ03H3ֽڿʼΪUnicodeַ,żΪ0x00)ʹóĬ˵
}USERCFG_343,*pUSERCFG_343;

//CH340CH341
typedef struct _USERCFG_340
{
	UCHAR SIG;        // CH340BڲϢЧ־ 5BH
	//ֵЧ
	UCHAR MODE;       //ģʽ23H 
	UCHAR CFG;        //оƬֽ
	//λ 5 òƷкַ0=Ч1=Ч
	UCHAR WP;         //ڲϢд־Ϊ 57H ֻɸд
	UCHAR Vid[2];     //Vendor IDʶ룬ֽںֵΪ 0000H  0FFFFH  VID  PID ʹóĬֵ
	UCHAR Pid[2];     //Product IDƷʶ룬ֽںֵ
	UCHAR Reserve1[2];//0x08-0x09
	UCHAR Power;      //Max PowerUSB,2mAΪλԴ
	UCHAR Reserve2[5];//0x0B-0x0F
	CHAR  SN[8];      //Serial NumberƷк ASCII ַΪ 8ֽڲ ASCII ַ21H7FHк
	UCHAR Reserve3[2];//0x18-0x19
	UCHAR PROD[38];   // CH340BProduct StringƷ˵ Unicode ַֽȫֽ 26Hֽ 03H֮ Unicode ַʹóĬ˵	
}USERCFG_340,*pUSERCFG_340;

//USER_XXоƬCH34XCH910X
//ȡоƬϢ,оƬͺšδ֪ͺ򷵻USER_TYPE_Unknown
UCHAR   WINAPI   CH343PT_GetChipProperty(HANDLE	       iPortHandle,   //ھֵ
										pChipPropertyS ChipProperty); //оƬGPIOEEPROMȹϢ

ULONG	WINAPI	CH343PT_GetVersion( );  // DLL汾,ذ汾

BOOL	WINAPI CH343PT_HandleIsCH34x(  // Ѿ򿪵Ķ˿ǷΪCH341˿
									 HANDLE		iPortHandle );  // ָѾ򿪵Ķ˿ھ


BOOL	WINAPI	CH343PT_NameIsCH34x(  // ָƵĶ˿ǷΪCH341˿
								   PUCHAR		iPortName );  // ָ˿,"COM3","COM15",ö˿ڱδռ(ָδ)


typedef		VOID	( CALLBACK	* mPCH343PT_NOTIFY_ROUTINE ) (  // ˿豸¼֪ͨص
															  LONG			iDevIndexAndEvent );  // ˿豸ź¼ǰ״̬(ο˵)
// iDevIndexAndEvent: ˵豸¼/Ѿ, ˵豸γ¼/Ѿγ, ֵ豸(1255)


BOOL	WINAPI	CH343PT_SetDevNotify(  // 趨˿豸¼֪ͨ
									PCHAR						iDeviceID,  // ѡ,ָ\0ַֹ,ָص豸ID߲ŵ,ڴڸòΪNULL"COM"
									mPCH343PT_NOTIFY_ROUTINE	iNotifyRoutine );  // ָ˿豸¼ص,ΪNULLȡ¼֪ͨ,ڼ⵽¼ʱøó
/* 弴豸Ӧó̲ο
	1. ĬǽֹݴģֻȷCH341˿ڿòҴ򿪶˿ںŽݴ
	2. CH343PtSetDevNotifyòμӣCH341˿ڵĲ¼DLLԶiNotifyRoutineָӳߺ
	3. Ӷ˿1˿25520ɣCH343PtNameIsCH341ȷǷΪCH341˿ڣ˿ںŲ򿪺ʼ䣬طϢ
	4. iNotifyRoutineյ¼֪ͨôڱ¼֪ͨҲڸӳд
	¼˵һ˿ڲ룬ҪʱӦCH343PtNameIsCH341жǷΪCH341˿ڣ˿ںŲ򿪺ʼ䣬
	Ǹ˵һ˿ڰγж˿ںţ0ȥøö˿ںţǷѴ򿪵Ķ˿ںͬӦüʱر
	5. ǰѾ򿪵Ķ˿ںӦñΪȫֱ, ˿δ򿪻߱رգôӦóӦֹͣݴ
	6. δCH343PtNameIsCH34XȷǷΪCH34x˿ڣôڶ˿Ѿ򿪺ҲԵCH343PtHandleIsCH34XжǷΪCH343˿
*/

//оƬģʽ:300bpsp;ɽзǱ׼úÿռд
BOOL WINAPI	CH343PT_EnterConfigMode(HANDLE iPortH);

//˳оƬģʽ:300bps
BOOL WINAPI	CH343PT_ExitConfigMode(HANDLE iPortH);

//ͨڶȡоƬEERPOM豸
BOOL    WINAPI	 CH343PT_ReadDevConfig(HANDLE          iPortH,     // ָCH341豸
									   PULONG          DataLen,    // Ҫȡݳ
									   PUCHAR          DataBuf);    // ݻ


//ͨоƬEERPOMд豸,дǰȷдλλѹرա
BOOL    WINAPI	 CH343PT_WriteDevConfig(HANDLE          iPortH,
										ULONG           BufferSize,
										PUCHAR          DataBuf);

//ͨоƬõEEPROMдݣÿֻдһֽ
BOOL	WINAPI	CH343PT_WriteCfgEeprom_Byte(HANDLE         iPortH,     // ָCH341豸	
											ULONG			iAddr,      // ָݵԪĵַ
											UCHAR			iByte );    // дֽ
//EEPROMֽڶ
BOOL	WINAPI	CH343PT_ReadCfgEeprom_Byte(  // I2Cӿڶȡһֽ
										   HANDLE          iPortH,    // ָCH341豸	
										   ULONG			iAddr,     // ָݵԪĵַ
										   PUCHAR			oByte );   // ָһֽڵԪ,ڱȡֽ

/*USBתоƬGPIOúͲ,USBתϵоƬCH910X*/
/* ***** ʹGPIO API, ֹ޸I/OʹűΪŵ֮·оƬ ***** */

//ʼGPIO,ǰִ
UCHAR	WINAPI	CH910x_GpioInit(HANDLE		iPortH);


// GPIOĹܺI/O
/* ***** ʹøAPI, ֹ޸I/OʹűΪŵ֮·оƬ ***** */
UCHAR	WINAPI	CH910x_GpioConfig(
								  HANDLE			iPortH,         // ھֵ
								  ChipPropertyS*  iChipProperty,
								  ULONG			iEnable,        // λʹ:λӦź,λ0ӦGPIO0,λ1ӦGPIO1;ĳλΪ1,ʾiGpioFunc,iSetDirOutӦλЧ											 
								  ULONG			iFuncSet,       // :ĳλֵΪ0,ʾӦΪоƬĬϹʹ;Ϊ1,ʾӦΪGPIOʹ;
								  ULONG			iSetDirOut);    // GPIOŷ:ĳλΪ0ʾӦŷΪ;ĳλΪ1ʾӦŷΪ

//ȡGPIO:Źܡ򡢵ƽiFuncSetiSetDirOutiSetDataOutλGPIOŶӦ
UCHAR	WINAPI	CH910x_GetGpioConfig(
									 HANDLE			iPortH,         // ھֵ
									 ChipPropertyS   *iChipProperty, // оƬϢΪNULL
									 PULONG			FuncSet,        // :ĳλֵΪ0,ʾӦΪоƬĬϹʹ;Ϊ1,ʾӦΪGPIOʹ;
									 PULONG			SetDirOut,      // GPIOŷ:ĳλΪ0ʾӦŷΪ;ĳλΪ1ʾӦŷΪ
									 PULONG          SetDataOut);    // GPIOŵƽֵ:1ʾߵƽ0ʾ͵ƽ

// ȡ豸
BOOL	WINAPI	CH343PT_GetDeviceDescr(  // ȡ豸
									   HANDLE			iPortHandle,        // ָCH341豸
									   PVOID			oBuffer,            // ָһ㹻Ļ,ڱ
									   PULONG			ioLength );          // ָ򳤶ȵԪ,ʱΪ׼ȡĳ,غΪʵʶȡĳ

// GPIOŵƽ״̬
UCHAR	WINAPI	CH910x_GpioSet(  
							   HANDLE			iPortH,         // ھֵ
							   ChipPropertyS*  iChipProperty,
							   ULONG			iEnable,        // Ч־,λGPIOxŶӦ,λֵΪ1ʾiSetDataOutĶӦλЧ,Ϊ0ʾЧ;
							   ULONG			iSetDataOut );  // IO,GPIOΪ,ôĳλ0ʱӦ͵ƽ,ĳλ1ʱӦߵƽ

//ȡGPIOŵƽ״̬
UCHAR	WINAPI	CH910x_GpioGet(   
							   HANDLE			iPortH,      // ھֵ
							   ChipPropertyS*   iChipProperty,
							   PULONG			iStatus );   // ״̬,GPIOxŶӦλšGPIO1ӦiStatusֵеbit1,CH910x_GPIO_xxλȡֵ

//ʹGPIOϵʼ
BOOL  WINAPI	CH910x_EnableGpioEepromConfig(
											  HANDLE		iPortH,             // ھֵ
											  BOOL         iEnable); //TRUE:ãFALSE:

// GPIOϵʱĳʼ״̬:ĬϹܡGPIO͵ƽ״ֵ̬õEEPROMڣϵоƬᰴֵá
// ֵʹãȷϺŷ͵ƽֹ·
BOOL  WINAPI	CH910x_SetGpioEepromConfig(  										 
										   HANDLE		iPortH,             // ھֵ
										   ULONG		iEnable,            // λʹ:λӦź,λ0ӦGPIO0,λ1ӦGPIO1;ĳλΪ1,ʾiGpioFunc,iSetDirOut,iSetDataOutӦλЧ											 
										   ULONG      iFuncSet,          // :ĳλֵΪ0,ʾӦΪоƬĬϹʹ;Ϊ1,ʾӦΪGPIOʹ;
										   ULONG		iSetDirOut,         // GPIOŷ:ĳλΪ0ʾӦŷΪ;ĳλΪ1ʾӦŷΪ
										   ULONG		iSetDataOut,        // GPIOŵƽ״̬:ĳλΪ1ʾߵƽΪ0ʾ͵ƽ
										   BOOL       IsImmediatelySet,   // ǷõEEPROM
										   PUCHAR     EepromData);        // ɵGPIOϵõEEPROM,ΪNULL

//ȡEepromGPIO:Źܡ򡢵ƽiFuncSetiSetDirOutiSetDataOutλGPIOŶӦ
UCHAR	WINAPI	CH910x_GetGpioEepromConfig(
										   HANDLE			iPortH,         // ھֵ	
										   PULONG			iFuncSet,       // :ĳλֵΪ0,ʾӦΪоƬĬϹʹ;Ϊ1,ʾӦΪGPIOʹ;
										   PULONG			iSetDirOut,     // GPIOŷ:ĳλΪ0ʾӦŷΪ;ĳλΪ1ʾӦŷΪ
										   PULONG           iSetDataOut);   // GPIOŵƽֵ:1ʾߵƽ0ʾ͵ƽ


//ȡGPIOãܺI/OĬֵ
UCHAR	WINAPI	CH348_GetGpioConfig(
									HANDLE		    	iPortH,         // ھֵ
									ChipPropertyS       *ChipProperty,  // оƬֵ
									ULONGLONG			*FuncSet,       // :ĳλֵΪ0,ʾӦΪоƬĬϹʹ;Ϊ1,ʾӦΪGPIOʹ;
									ULONGLONG			*SetDirOut,     // GPIOŷ:ĳλΪ0ʾӦŷΪ;ĳλΪ1ʾӦŷΪ	
									ULONGLONG           *SetDataOut);   // IO,GPIOΪ,ôĳλ0ʱӦ͵ƽ,ĳλ1ʱӦߵƽ


// GPIOĹܺI/O
//iEnable,iFuncSet,iSetDirOutΪ64λλGPIOźŶӦ
//ʹǰȵCH348_GetGpioConfigȡiFuncSet,iSetDirOutֵٽ
UCHAR	WINAPI	CH348_GpioConfig(
								 HANDLE		    	iPortH,         // ھֵ
								 ChipPropertyS*      iChipProperty,  // оƬֵ
								 ULONGLONG			iEnable,        // λʹ:λӦź,λ0ӦGPIO0,λ1ӦGPIO1;ĳλΪ1,ʾiGpioFunc,iSetDirOutӦλЧ											 
								 ULONGLONG			iFuncSet,       // :ĳλֵΪ0,ʾӦΪоƬĬϹʹ;Ϊ1,ʾӦΪGPIOʹ;
								 ULONGLONG			iSetDirOut,     // GPIOŷ:ĳλΪ0ʾӦŷΪ;ĳλΪ1ʾӦŷΪ	
								 ULONGLONG           iSetDataOut);    // IO,GPIOΪ,ôĳλ0ʱӦ͵ƽ,ĳλ1ʱӦߵƽ

// ĳGPIOŵƽ״̬,Ӧ迪GPIO
UCHAR	WINAPI	CH348_GpioSet(  
							  HANDLE			iPortH,         // ھֵ
							  ChipPropertyS*   iChipProperty,  // оƬֵ
							  UCHAR	        iGpioIndex,     // GPIO,0-63
							  UCHAR		    iGpioLevel );   // GPIOƽ1Ϊߵƽ1͵ƽ

// öGPIOŵƽ״̬,Ӧ迪GPIO
UCHAR	WINAPI	CH348_GpioMSet(  
							   HANDLE			iPortH,          // ھֵ
							   ChipPropertyS*   iChipProperty,   // оƬֵ
							   ULONGLONG        iGpioMIndex,     // GPIO룬λ0-63
							   ULONGLONG		iGpioMLevel);     // GPIOƽ룬iGpioMIndexλöӦ1ߵƽ0͵ƽ

// ȡĳGPIOŵƽ״̬,Ӧ迪GPIO
UCHAR	WINAPI	CH348_GpioGet(  
							  HANDLE			iPortH,         // ھֵ
							  ChipPropertyS*   iChipProperty,  // оƬֵ
							  UCHAR	        iGpioIndex,     // GPIO 0-63
							  PUCHAR		    GpioLevel );     // GPIOƽ1Ϊߵƽ1͵ƽ

// ȡGPIOŵƽ״̬,Ӧ迪GPIO
UCHAR	WINAPI	CH348_GpioMGet(  
							   HANDLE			iPortH,          // ھֵ
							   ChipPropertyS*   iChipProperty,   // оƬֵ
							   ULONGLONG        iGpioMIndex,     // GPIO룬λ0-63
							   ULONGLONG*	    GpioMLevel );    // GPIOƽ룬iGpioMIndexλöӦ1ߵƽ0͵ƽ
//õEEPROMдһֽ
BOOL	WINAPI	CH348_WriteCfgEeprom_Byte(HANDLE        iPortH,     // ھֵ
										  ChipPropertyS *ChipProperty,  // оƬֵ
										  UCHAR			iAddr,      // ָݵԪĵַ
										  UCHAR			iByte );    // дֽ

//õEEPROMڶһֽ
BOOL	WINAPI	CH348_ReadCfgEeprom_Byte(HANDLE         iPortH,    // ھֵ	
										 ChipPropertyS  *ChipProperty,  // оƬֵ
										 UCHAR			iAddr,     // ָݵԪĵַ
										 PUCHAR			oByte );   // ָһֽڵԪ,ڱȡֽ
//ͨڶȡоƬEERPOM豸
BOOL    WINAPI	 CH348_ReadDevConfig(
									 HANDLE          iPortH,     // ھֵ
									 ChipPropertyS  *ChipProperty,  // оƬֵ
									 PULONG          DataLen,    // Ҫȡݳ
									 PUCHAR          DataBuf);    // ݻ
//ͨоƬEERPOMд豸,дǰȷдλλѹرա
BOOL    WINAPI	 CH348_WriteDevConfig(
									  HANDLE          iPortH,				// ھֵ
									  ChipPropertyS  *ChipProperty,  // оƬֵ
									  ULONG           BufferSize,    // Ҫдݳ 
									  PUCHAR          DataBuf);       // ݻ
//оƬCH340/1
ULONG	WINAPI	CH341PtGetVersion( );  // DLL汾,ذ汾

BOOL	WINAPI	CH341PtHandleIsCH341(  // Ѿ򿪵Ķ˿ǷΪCH341˿
									 HANDLE		iPortHandle );  // ָѾ򿪵Ķ˿ھ


BOOL	WINAPI	CH341PtNameIsCH341(  // ָƵĶ˿ǷΪCH341˿
								   PUCHAR		iPortName );  // ָ˿,"COM3","COM15",ö˿ڱδռ(ָδ)


typedef		VOID	( CALLBACK	* mPCH341PT_NOTIFY_ROUTINE ) (  // ˿豸¼֪ͨص
															  LONG			iDevIndexAndEvent );  // ˿豸ź¼ǰ״̬(ο˵)
// iDevIndexAndEvent: ˵豸¼/Ѿ, ˵豸γ¼/Ѿγ, ֵ豸(1255)


BOOL	WINAPI	CH341PtSetDevNotify(  // 趨˿豸¼֪ͨ
									PCHAR						iDeviceID,  // ѡ,ָ\0ַֹ,ָص豸ID߲ŵ,ڴڸòΪNULL"COM"
									mPCH341PT_NOTIFY_ROUTINE	iNotifyRoutine );  // ָ˿豸¼ص,ΪNULLȡ¼֪ͨ,ڼ⵽¼ʱøó
																				   /* 弴豸Ӧó̲ο
																				   1. ĬǽֹݴģֻȷCH341˿ڿòҴ򿪶˿ںŽݴ
																				   2. CH341PtSetDevNotifyòμӣCH341˿ڵĲ¼DLLԶiNotifyRoutineָӳߺ
																				   3. Ӷ˿1˿25520ɣCH341PtNameIsCH341ȷǷΪCH341˿ڣ˿ںŲ򿪺ʼ䣬طϢ
																				   4. iNotifyRoutineյ¼֪ͨôڱ¼֪ͨҲڸӳд
																				   ¼˵һ˿ڲ룬ҪʱӦCH341PtNameIsCH341жǷΪCH341˿ڣ˿ںŲ򿪺ʼ䣬
																				   Ǹ˵һ˿ڰγж˿ںţ0ȥøö˿ںţǷѴ򿪵Ķ˿ںͬӦüʱر
																				   5. ǰѾ򿪵Ķ˿ںӦñΪȫֱ, ˿δ򿪻߱رգôӦóӦֹͣݴ
																				   6. δCH341PtNameIsCH341ȷǷΪCH341˿ڣôڶ˿Ѿ򿪺ҲԵCH341PtHandleIsCH341жǷΪCH341˿
*/


//ָIDȡ豸Ϣش豸ǷѰװ
BOOL	WINAPI	CH343PT_GetUsbDevDrvInfor(USHORT PID,             //оƬUSB PID
										  BOOL   *DrvIsInstalled, //ǷҪװ
										  PCHAR  DriverInfo);     //оƬϢ,ΪNULL

BOOL	WINAPI	CH343PT_StartFwUpate(HANDLE			iPortH,        // ָCH341豸
									 ULONG			FwSize);       // ̼

//ȡ豸BCD
BOOL	WINAPI	CH343PT_GetUsbComDevBcd(HANDLE			iPortH, 
                                        USHORT          *oDevBCD);


/*
ߴISPԶط--CH342/3
1.Χܵ߼Ƶ·ʹUSBתоƬCH342/3ʵMCU BOOTAPPģʽIOл͹̼.
2.ΪҪдͼCH340ΪӲԭο
3.˿ɼCH342/3USBԶأγԶرն˿ڡ
4.ʵCH32xxxx/STM32F103ȵƬʱƺʹͨѶ
5.ִ֧˹ܵUSBתͺ:CH343G/CH343P/CH342F
/*

1.򿪴
2.MCUģʽ
CH343PT_SetMcuStartupMode
McuSeries: 103MCU/CH32xxxxMCUʽ:BOOT0ߵƽЧRST͵ƽЧ
PinCombMode:0:CTS->MCU BOOT0,RTS->MCU RST,BOOT1=GND
1:CTS->MCU BOOT0,RTS->MCU RST,DSR->MCU BOOT1
3.ϵͳ(BOOT)MCU
CH343PT_McuStartupFromSystem();
4.ISPغ
5.FlashMCUû
CH343PT_McuStartupFromFlash();
6.رմ
*/

#define LEVEL_LOW    0
#define LEVEL_HIGH   1
#define IOFUNC_GPI   0
#define IOFUNC_GPO   1
/*
McuSeries: 103MCU/CH32xxxxMCUʽ:BOOT0ߵƽЧRST͵ƽЧ
PinCombMode:ϣ0:CTS->MCU BOOT0,RTS->MCU RST,BOOT1=GND
1:CTS->MCU BOOT0,RTS->MCU RST,DSR->MCU BOOT1
StartupMode	BOOT0	BOOT1	˵
0         0	     X	    FLASH(APP)
1         1	     0	    ϵͳ洢(BOOT,)
2         1	     1	    SRAM
*/
//MCUģʽ
UCHAR	WINAPI	WINAPI	CH343PT_SetMcuStartupMode(HANDLE PortH,     //
												  UCHAR McuSeries,  //MCUϵ 0:103 MCU,CH32xxxxϵоƬʽ
												  UCHAR PinCombMode,
												  //ϣ0:CTS->MCU BOOT0,RTS->MCU RST,BOOT1=GND
												  //              1:CTS->MCU BOOT0,RTS->MCU RST,DSR->MCU BOOT1
												  ULONG ResetHoldTime); //λʱ
//FlashMCU
UCHAR	WINAPI	CH343PT_McuStartupFromFlash();
//ϵͳ(BOOT)MCU
UCHAR	WINAPI	CH343PT_McuStartupFromSystem();
//SRAMMCU
UCHAR	WINAPI	CH343PT_McuStartupFromSram();

//DTR/RTSڴδʱĵƽֵֻʱЧ
BOOL	WINAPI	CH343PT_SetModemOutLevelOnClosed(HANDLE PortH,
												 BOOL   EnRtsKeepSetOnClosed, //TRUE:ΪTTL͵ƽ;FALSE:ΪߵƽΪĬֵ
												 BOOL   EnDtrKeepSetOnClosed);//TRUE,ΪTTL͵ƽ;FALSE:ΪߵƽΪĬֵ

/*
ߴISPԶӲ---CH340
CH340E/C֧DTRǿģʽΧ·ĶģʽMCU,÷ʽCH340DS1.PDF5.3
1.·ɿϵ硢硢򿪡رյȲӰMCUģʽͳһص·Ҫ2ʹԱBOOT̬͵ƽԼֹжʱMCUλBOOTģʽ
2.MCU޸ġ
3.֧һءUSBȲԺCH343PTο⺯ʵֲԶء
4.ṩMSOP10ESSOP10SOP8ȷװɶƷװ
5.ΪоƬӲοCH342/3
*/
//ǿչ
#define DTR_EXFUNC_NULL     0  
//CH340EоƬTNOWŸDTR̬͵ƽSTM32Fxxx/CH32V/FxxxϵMCUؿƣΧ·
#define DTR_EXFUNC_MODE_L   1  
//CH340EоƬTNOWŸDTR/CH340C OUTŸDTR̬ߵƽSTM32Fxxx/CH32V/FxxxϵMCUؿƣΧ·
#define DTR_EXFUNC_MODE_H   2
//ȡоƬDTRģʽ,CH340E/C֧DTRǿģʽΧ·ĶģʽMCUء
BOOL	WINAPI	CH343PT_GetDTRMode(HANDLE			iPortH,          // ھ
							       UCHAR			*DTRExFuncMode); // ģʽDTR_EXFUNC_xxx

#ifdef __cplusplus
}
#endif

#endif		// _CH343_PORT_H
